#!/bin/bash

#BASE_URL="https://ec2-52-70-138-175.compute-1.amazonaws.com"
BASE_URL="http://localhost:8089"
ICN="1006088937V099668"
JWT=$(curl "$BASE_URL/jwt" -H "va_eauth_icn: $ICN" --insecure)

echo $JWT

## Step 1 Set up preference

echo { \
  		\"patientIdentifier\": { \
    		\"uniqueId\": \"$ICN\", \
   		 	\"assigningAuthority\": \"ICN\" \
  		}, \
  		\"timeZone\": \"\(-4:00\) America\/New_York\", \
  		\"emailAddress\": \"lnorcross@yahoo.com\" \
		} > preference.json 

curl -X POST "$BASE_URL/pns/v1/patient/ICN/$ICN/preferences" -d @preference.json -H "accept: application/json" -H "Content-Type: application/json" -H "X-VAMF-JWT: $JWT" --insecure | jq

## Step 2 Step 2 Set up notification preference

echo { \
  \"patientIdentifier\": { \
    \"uniqueId\": \"$ICN\", \
    \"assigningAuthority\": \"ICN\" \
  }, \
  \"optInSelected\": true, \
  \"createDate\": \"2017-09-12T13:00:47.780Z\", \
  \"optInLastModifiedDate\": \"2017-09-12T13:00:47.780Z\", \
  \"firstName\": \"string\", \
  \"lastName\": \"string\", \
  \"dateOfBirth\": \"2017-09-12T13:00:47.780Z\", \
  \"selfLink\": { \
    \"title\": \"string\", \
    \"type\": \"string\", \
    \"hreflang\": \"string\", \
    \"length\": \"string\" \
  }, \
  \"selfUri\": \"string\" \
} > notification-preference.json

curl -X POST "$BASE_URL/pns/v1/patient/ICN/$ICN/patient-notification-preference" -H "accept: application/json" -H "Content-Type: application/json" -d @notification-preference.json -H "X-VAMF-JWT: $JWT" --insecure | jq

## Step 3 Create Notification 

echo { \
  \"patientIdentifier\": { \
    \"uniqueId\": \"$ICN\", \
    \"assigningAuthority\": \"ICN\" \
  }, \
  \"readFlag\": true, \
  \"deletedFlag\": false, \
  \"body\": \"string\", \
  \"source\": \"string\", \
  \"type\": \"string\", \
  \"createDate\": \"2017-09-12T12:03:01.911Z\", \
  \"effectiveDisplayDate\": \"2017-09-12T12:03:01.911Z\", \
  \"timeZone\": \"\(-4:00\) America\/New_York\", \
  \"readDate\": \"2017-09-12T12:03:01.911Z\", \
  \"selfLink\": { \
    \"title\": \"string\", \
    \"type\": \"string\", \
    \"hreflang\": \"string\", \
    \"length\": \":string\" \
  }, \
  \"selfUri\": \"string\" \
} > notification.json


ID=$(curl -X POST "$BASE_URL/pns/v1/patient/ICN/$ICN/notifications" -H "accept: application/json" -H "Content-Type: application/json" -d @notification.json -H "X-VAMF-JWT: $JWT" --insecure | jq -r '.id')

## Update notification

echo { \
  \"id\": \"$ID\", \
  \"patientIdentifier\": { \
    \"uniqueId\": \"$ICN\", \
    \"assigningAuthority\": \"ICN\" \
  }, \
  \"readFlag\": true, \
  \"deletedFlag\": false, \
  \"body\": \"updated value\", \
  \"source\": \"string\", \
  \"type\": \"string\", \
  \"createDate\": \"2017-09-12T12:03:01.911Z\", \
  \"effectiveDisplayDate\": \"2017-09-12T12:03:01.911Z\", \
  \"timeZone\": \"America\/New_York\", \
  \"readDate\": \"2017-09-12T12:03:01.911Z\", \
  \"selfLink\": { \
    \"title\": \"string\", \
    \"type\": \"string\", \
    \"hreflang\": \"string\", \
    \"length\": \":string\" \
  }, \
  \"selfUri\": \"string\" \
} > notification-update.json

curl -X PUT "$BASE_URL/pns/v1/patient/ICN/$ICN/notifications/$ID" -H "accept: application/json" -H "Content-Type: application/json" -d @notification-update.json -H "X-VAMF-JWT: $JWT" --insecure | jq

## GET notification
curl -X GET "$BASE_URL/pns/v1/patient/ICN/$ICN/notifications/$ID" -H "accept: application/json" -H "Content-Type: application/json" -H "X-VAMF-JWT: $JWT" --insecure | jq

## Delete notification

curl -X DELETE "$BASE_URL/pns/v1/patient/ICN/$ICN/notifications/$ID" -H "accept: application/json" -H "Content-Type: application/json" -H "X-VAMF-JWT: $JWT" --insecure 

## check its marked as deleted
curl -X GET "$BASE_URL/pns/v1/patient/ICN/$ICN/notifications/$ID" -H "accept: application/json" -H "Content-Type: application/json" -H "X-VAMF-JWT: $JWT" --insecure | jq


